package com.burhanstore.neonbubblequest

import android.content.Context
import android.content.SharedPreferences
import com.burhanstore.neonbubblequest.Utils.network.PrefManager

object AppConst {

    val Base_URL = "https://neonbubblequest.burhanstoreapp.xyz/"

    val PAYMENT_IMG_PTAH = Base_URL + "images/upload/payment/"


    //set user data
    const val USER_COIN = "user_coin"


    @Volatile
    private var prefManager: PrefManager? = null

    private fun getPrefManager(context: Context): PrefManager {
        return prefManager ?: synchronized(this) {
            prefManager ?: PrefManager(context.applicationContext).also { prefManager = it }
        }
    }

    fun setString(context: Context, key: String, value: String) {
        getPrefManager(context).setString(key, value)
    }

    fun getString(context: Context, key: String): String {
        return getPrefManager(context).getString(key)
    }


}